//
//  MCReportUserInput.h
//  MCReporting
//
//  Created by Alykhan Jetha on 06/03/06.
//  Copyright 2006 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>


typedef enum _MCReportUserInputKind {
    MCReportUserInputTextDescriptionKind		= 0,
    MCReportUserInputTextFieldKind		 		= 1,
    MCReportUserInputDateKind					= 2,
    MCReportUserInputDateRangeKind		 		= 3,
    MCReportUserInputPopupMenuKind		 		= 4,
    MCReportUserInputElementChoiceKind		 	= 5
} MCReportUserInputKind;

extern NSString *MCReportUserInputKindCodeKey;
extern NSString *MCReportUserInputKindNameKey;
extern NSString *MCReportUserInputMandatoryKey;
extern NSString *MCReportUserInputLabelKey;
extern NSString *MCReportUserInputKeypathKey;
extern NSString *MCReportUserInputSecondKeypathKey;


@interface MCReportUserInput : NSObject {

}

+ (Class)editorClassForUserInputKind:(MCReportUserInputKind)aKind;
+ (Class)viewClassForUserInputKind:(MCReportUserInputKind)aKind;

+ (NSMutableDictionary *)newDataDictionaryForUserInput:(MCReportUserInputKind)aKind;


@end
